#pragma once

#include "calling_messages_sender.h"
#include "call/call_transport.h"
#include "call/request_id.h"

#include <yandex_io/callkit/calls/types.h>
#include <yandex_io/callkit/rtc/media/transport.h>
#include <yandex_io/callkit/util/cancelable.h>
#include <yandex_io/callkit/util/weak_utils.h>

#include <deque>
#include <memory>
#include <string>
#include <vector>

namespace messenger {

    class CallingMessageReceiver;
    class LoopThread;

    namespace rtc {
        class DeviceInfo;
    } // namespace rtc

    // on: worker thread
    class MessengerCallTransport
        : public rtc::Transport,
          public CallTransport,
          public std::enable_shared_from_this<MessengerCallTransport> {
        CREATE_FROM_INIT(MessengerCallTransport);

    public:
        virtual ~MessengerCallTransport();

        void initialize(const std::string& callGuid);
        void delayedDispose();

        // rtc::Transport
        void send(const rtc::Transport::Message& message) override;
        void setListener(std::weak_ptr<rtc::Transport::Listener> listener) override;

        // CallTransport
        RequestId makeCall(std::shared_ptr<rtc::DeviceInfo> deviceInfo) override;
        RequestId acceptCall(std::shared_ptr<rtc::DeviceInfo> deviceInfo) override;
        RequestId declineCall() override;
        RequestId endCall() override;
        RequestId notifyRinging() override;
        void dispose() override;

    private:
        void init(
            std::shared_ptr<CallingMessagesSender> callingMessagesSender,
            std::shared_ptr<LoopThread> workerThread,
            const std::string& deviceId, const std::string& receiverDeviceId,
            const std::string& chatId, const std::string& callGuid);

        RequestId enqueueMessage(proto::CallingMessage callingMessage);
        bool dequeueMessage(const RequestId& requestId);
        void flushQueue();
        void trySend();

        proto::CallingMessage
        buildMakeCallMessage(std::shared_ptr<rtc::DeviceInfo> deviceInfo);
        proto::CallingMessage
        buildMediaTransportMessage(const rtc::Transport::Message& message);
        proto::CallingMessage
        buildAcceptCallMessage(std::shared_ptr<rtc::DeviceInfo> deviceInfo);
        proto::CallingMessage buildDeclineCallMessage();
        proto::CallingMessage buildEndCallMessage();
        proto::CallingMessage buildCallingMessage();

        void onMessageReceived(proto::CallingMessage message, proto::ServerMessage serverMessage);
        void onAckReceived(const std::string& payloadId);
        void onErrorReceived(const std::string& payloadId,
                             proto::PostMessageResponse response);

        std::shared_ptr<CallingMessagesSender> callingMessagesSender_;
        std::shared_ptr<LoopThread> workerThread_;
        std::shared_ptr<CallingMessageReceiver> receiver_;
        std::string deviceId_;
        std::string receiverDeviceId_;
        std::string chatId_;

        using QueueMessage = std::pair<RequestId, proto::CallingMessage>;
        std::deque<QueueMessage> sendQueue_;
        std::vector<Cancelable> allRequests_;
        uint64_t sendSequenceNumber_;

        std::string callGuid_;

        CallingMessagesSender::CallingMessageSubscription messageSubscription_;
        CallingMessagesSender::AckReceivedSubscription ackSubscription_;
        CallingMessagesSender::ErrorReceivedSubscription errorSubscription_;
    };

} // namespace messenger
