#pragma once

// forward declarations of used types

#include <contrib/libs/cxxsupp/libcxx/include/memory>

#include <mssngr/router/lib/protos/message.pb.h>

namespace NMessengerProtocol {
    class TCallingMessage;
    class TCallingMessage_TCallAccepted;
    class TCallingMessage_TTransportMessage;
    class TResponse;
    class TServerMessage;
} // namespace NMessengerProtocol

namespace messenger {
    namespace proto {

        using CallingMessage = std::shared_ptr<NMessengerProtocol::TCallingMessage>;
        using PostMessageResponse = std::shared_ptr<NMessengerProtocol::TResponse>;
        using ServerMessage = std::shared_ptr<NMessengerProtocol::TServerMessage>;
        using TransportMessage =
            std::shared_ptr<NMessengerProtocol::TCallingMessage_TTransportMessage>;
        using TransportMessage =
            std::shared_ptr<NMessengerProtocol::TCallingMessage_TTransportMessage>;
        using CallAccepted =
            std::shared_ptr<NMessengerProtocol::TCallingMessage_TCallAccepted>;

        enum CommitStatus {
            BAD_REQUEST = 13,
            CONFLICT = 16,
            BLOCKED_BY_PRIVACY_SETTINGS = 24,
        };

        template <typename SharedPtr>
        SharedPtr make() {
            return std::make_shared<typename SharedPtr::element_type>();
        }

        template <class Msg>
        std::shared_ptr<Msg> clone(const Msg* msg) {
            std::shared_ptr<Msg> p(msg->New());
            p->CopyFrom(*msg);
            return p;
        }

        template <class Msg>
        std::shared_ptr<Msg> clone(const Msg& msg) {
            std::shared_ptr<Msg> p(msg.New());
            p->CopyFrom(msg);
            return p;
        }

    } // namespace proto
} // namespace messenger
