#include "cli.h"

#include <yandex_io/callkit/messenger_tool/cli_io.h>
#include <yandex_io/callkit/messenger_tool/commands/direct_tool_processor.h>

#include <yandex_io/libs/base/utils.h>

using namespace messenger;

int messenger::cli(
    std::shared_ptr<messenger::Session> session,
    int argc,
    char** argv)
{
    std::string commandsFile = std::string(argv[0]) + ".qdata";

    for (int i = 1; i + 1 < argc; ++i) {
        if (strcmp(argv[i], "-f") == 0) {
            commandsFile = std::string(argv[i + 1]);
            break;
        }
    }

    std::string commandData;

    if (quasar::fileExists(commandsFile)) {
        YIO_LOG_DEBUG("Using commands from " << commandsFile);
        commandData = quasar::getFileContent(commandsFile);

    } else {
        YIO_LOG_DEBUG("Commands file doesn't exist: " << commandsFile);
    }

    auto io = std::make_shared<messenger::CliIO>();

    DirectToolProcessor toolProcessor(io, std::move(session));

    if (!commandData.empty()) {
        toolProcessor.execute(commandData);
    }
    while (true) {
        std::string command = io->getLine();
        if (command == "q" || command == "quit" || command == "exit") {
            break;
        }
        toolProcessor.execute(command);
    }

    return 0;
}
