#include "client_request_task.h"

YIO_DEFINE_LOG_MODULE("callkit");

using namespace messenger;

ClientRequestTask::ClientRequestTask() = default;
ClientRequestTask::~ClientRequestTask() = default;

void ClientRequestTask::prepareRequest(
    NMessengerProtocol::TInMessage* message) {
    message->mutable_meta()->set_origin(NMessengerProtocol::YASTATION_MINI);
    auto* clientMessage = message->mutable_clientmessage();
    clientMessage->set_issilent(false);
    prepareClientMessage(clientMessage);
}

std::string ClientRequestTask::getPath() {
    return "push";
}

void ClientRequestTask::onError() {
    YIO_LOG_ERROR_EVENT("ClientRequestTask.OnError", getName() + ": error");
    handleError(proto::PostMessageResponse());
}

void ClientRequestTask::handleResponse(proto::PostMessageResponse /*response*/) {
}

bool ClientRequestTask::handleError(proto::PostMessageResponse /*response*/) {
    return true; // retry by default
}

bool ClientRequestTask::onResultMessage(
    std::shared_ptr<NMessengerProtocol::TResponse> message) {
    YIO_LOG_INFO(getName() + ": status " + std::to_string(message->status()));
    if (isStatusSuccess(message->status())) {
        handleResponse(message);
        return false;
    } else {
        return handleError(message);
    }
}

bool ClientRequestTask::isStatusSuccess(
    NMessengerProtocol::ECommitStatus status) {
    switch (status) {
        case NMessengerProtocol::ECommitStatus::FullyCommitted:
        case NMessengerProtocol::ECommitStatus::Duplicate:
            return true;
        default:
            return false;
    }
}

bool ClientRequestTask::isStatusRetryable(
    NMessengerProtocol::ECommitStatus status) {
    switch (status) {
        case NMessengerProtocol::ECommitStatus::SenderNotInChat:
        case NMessengerProtocol::ECommitStatus::NoSuchChat:
        case NMessengerProtocol::ECommitStatus::MessageNotFound:
        case NMessengerProtocol::ECommitStatus::BadRequest:
        case NMessengerProtocol::ECommitStatus::RateLimitExceeded:
        case NMessengerProtocol::ECommitStatus::NotFound:
        case NMessengerProtocol::ECommitStatus::SpamDetected:
        case NMessengerProtocol::ECommitStatus::Blacklisted:
        case NMessengerProtocol::ECommitStatus::Banned:
        case NMessengerProtocol::ECommitStatus::NoPermission:
        case NMessengerProtocol::ECommitStatus::NoSuchUser:
            return false;
        case NMessengerProtocol::ECommitStatus::Conflict:
        case NMessengerProtocol::ECommitStatus::DequeuedAfterError:
        case NMessengerProtocol::ECommitStatus::Failed:
        case NMessengerProtocol::ECommitStatus::FileshareFailed:
        case NMessengerProtocol::ECommitStatus::ForeignPartition:
        case NMessengerProtocol::ECommitStatus::KikimrWriteFailed:
        case NMessengerProtocol::ECommitStatus::NotLeading:
        case NMessengerProtocol::ECommitStatus::PostprocCommitted:
        case NMessengerProtocol::ECommitStatus::Throttled:
        case NMessengerProtocol::ECommitStatus::Uncommitted:
        case NMessengerProtocol::ECommitStatus::UniproxyCommitted:
            return true;
        case NMessengerProtocol::ECommitStatus::FullyCommitted:
        case NMessengerProtocol::ECommitStatus::Duplicate:
            Y_VERIFY(!"Not reached, check isStatusSuccess()");
        default:
            return true;
    }
}
