#pragma once

#include "base_request_task.h"

#include <mssngr/router/lib/protos/client.pb.h>
#include <mssngr/router/lib/protos/message.pb.h>
#include <yandex_io/callkit/calls/types.h>

#include <yandex_io/libs/logging/logging.h>

namespace messenger {

    class ClientRequestTask: public RequestTask<NMessengerProtocol::TInMessage,
                                                NMessengerProtocol::TResponse> {
    public:
        ClientRequestTask();
        virtual ~ClientRequestTask();

    protected:
        virtual void
        prepareClientMessage(NMessengerProtocol::TClientMessage* clientMessage) = 0;
        virtual void handleResponse(proto::PostMessageResponse message);
        // message can be null, return true to retry the request
        virtual bool handleError(proto::PostMessageResponse message);

    private:
        void prepareRequest(NMessengerProtocol::TInMessage* message) final;
        std::string getPath() final;
        void onError() final;
        bool onResultMessage(
            std::shared_ptr<NMessengerProtocol::TResponse> message) final;

        static bool isStatusSuccess(NMessengerProtocol::ECommitStatus status);
        static bool isStatusRetryable(NMessengerProtocol::ECommitStatus status);
    };

} // namespace messenger
