#pragma once

#include <yandex_io/callkit/session/session_settings.h>
#include <yandex_io/callkit/xiva/socket_api.h>

#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/telemetry/telemetry.h>

#include <functional>
#include <memory>
#include <queue>

namespace messenger {

    class DataStorage;
    class DedicatedSocket;
    class LoopThread;
    class PushHandler;
    class RequestHandler;
    struct BaseRequestTask;
    struct SessionSettings;

    // on: worker
    class ConnectionService {
    public:
        ConnectionService(const std::shared_ptr<quasar::ipc::IIpcFactory>& ipcFactory,
                          const SessionSettings& settings,
                          std::shared_ptr<LoopThread> workerThread,
                          std::shared_ptr<DataStorage> dataStorage,
                          std::shared_ptr<YandexIO::ITelemetry> telemetry);
        virtual ~ConnectionService();

        bool isConnected() const;

        void sendHeartbeat();

        bool hasBgTasks() const;
        void runOnBgIdle(std::function<void()> callback);

        std::shared_ptr<PushHandler> getPushHandler() const;
        std::shared_ptr<RequestHandler> getRequestHandler() const;

    private:
        void processTask(std::shared_ptr<BaseRequestTask> task);

        bool destroyed_;
        SessionSettings settings_;
        std::shared_ptr<LoopThread> workerThread_;
        std::shared_ptr<DataStorage> dataStorage_;
        std::shared_ptr<xiva::SocketApi> socket_;
        std::shared_ptr<RequestHandler> requestHandler_;
        std::shared_ptr<PushHandler> pushHandler_;
    };

} // namespace messenger
