#pragma once

#include <yandex_io/callkit/session/session_settings.h>
#include <yandex_io/callkit/util/observer_list.h>
#include <yandex_io/callkit/xiva/socket_api.h>

#include <yandex_io/libs/base/named_callback_queue.h>
#include <yandex_io/libs/telemetry/telemetry.h>
#include <yandex_io/libs/websocket/websocket.h>

#include <functional>
#include <memory>
#include <string>
#include <vector>

namespace quasar {
    class WebsocketClient;
} // namespace quasar

namespace messenger {

    class DataStorage;
    class SessionApiService;

    // This implementation is not for production - no reconnections, no error
    // handling.
    //
    // on: any thread
    class DedicatedSocket: public xiva::SocketApi {
    public:
        DedicatedSocket(const SessionSettings& settings,
                        std::shared_ptr<DataStorage> dataStorage,
                        std::shared_ptr<YandexIO::ITelemetry> telemetry);
        virtual ~DedicatedSocket();

        std::vector<std::string> getServiceNames() override;

        void sendBinaryData(const std::string& buffer,
                            FailCallback onFail = FailCallback()) override;
        void sendTextData(const std::string& buffer,
                          FailCallback onFail = FailCallback()) override;

    private:
        void connect();
        void disconnect();
        void onTextMessage(const std::string& msg);
        void onBinaryMessage(const std::string& msg);
        void onConnected();
        void onDisconnected(const quasar::Websocket::ConnectionInfo& /*info*/);
        void onFail(const quasar::Websocket::ConnectionInfo& /*info*/);

        SessionSettings settings_;
        std::shared_ptr<DataStorage> dataStorage_;
        CallbackSubscription setupXivaSubscription_;
        std::unique_ptr<quasar::WebsocketClient> webClient_;
        quasar::NamedCallbackQueue callbackQueue_{"DedicatedSocket"};
    };

} // namespace messenger
