#include "push_handler.h"

#include "messenger_protocol.h"

#include <mssngr/router/lib/protos/client.pb.h>
#include <yandex_io/callkit/util/loop_thread.h>
#include <yandex_io/callkit/util/weak_utils.h>

#include <yandex_io/libs/logging/logging.h>

using namespace messenger;

PushHandler::PushHandler(std::shared_ptr<LoopThread> workerThread,
                         std::shared_ptr<xiva::Transport> xivaTransport)
    : workerThread_(std::move(workerThread))
    , xivaTransport_(std::move(xivaTransport))
{
    auto weakLoop = weak_from(workerThread_);
    pushSubscription_ = xivaTransport_->subscribeOnPush(
        [this, weakLoop](const std::string& data) {
            if (auto loop = weakLoop.lock()) {
                loop->execute([this, data] { onPushReceived(data); });
            }
        });
}

PushHandler::~PushHandler() = default;

void PushHandler::onPushReceived(const std::string& framePayload) {
    auto proto = extractPushPayload(framePayload);
    YIO_LOG_DEBUG("onPushReceived: " << proto.size());
    if (proto.empty()) {
        YIO_LOG_WARN("Skipping unhandled push message");
        return;
    }
    auto message = proto::make<proto::ServerMessage>();
    Y_PROTOBUF_SUPPRESS_NODISCARD message->ParseFromString(TString(proto));
    YIO_LOG_INFO("Push received: " << message->servermessageinfo().timestamp());
#ifndef _NDEBUG // avoid personal message data in logs?
    YIO_LOG_DEBUG(message->ShortDebugString());
#endif
    onServerMessage.notifyObservers(message);
}
