#pragma once

#include <yandex_io/callkit/calls/types.h>
#include <yandex_io/callkit/util/observer_list.h>
#include <yandex_io/callkit/xiva/transport.h>

#include <memory>
#include <string>

namespace messenger {

    namespace xiva {
        class Transport;
    } // namespace xiva

    class LoopThread;

    // on: worker
    class PushHandler {
    public:
        using Observer = ObserverList<proto::ServerMessage>::ObserverType;
        using Subscription = ObserverList<proto::ServerMessage>::ScopedSubscription;

        PushHandler(std::shared_ptr<LoopThread> workerThread,
                    std::shared_ptr<xiva::Transport> xivaTransport);
        virtual ~PushHandler();

        ObserverList<proto::ServerMessage> onServerMessage;

    private:
        void onPushReceived(const std::string& framePayload);

        std::shared_ptr<LoopThread> workerThread_;
        std::shared_ptr<xiva::Transport> xivaTransport_;

        xiva::Transport::PushSubscription pushSubscription_;
    };

} // namespace messenger
