#pragma once

#include <yandex_io/callkit/session/session_settings.h>
#include <yandex_io/callkit/xiva/socket_api.h>

#include <yandex_io/libs/ipc/i_ipc_factory.h>

namespace messenger {

    class PushdSocket: public xiva::SocketApi {
    public:
        explicit PushdSocket(const std::shared_ptr<quasar::ipc::IIpcFactory>& ipcFactory, const std::vector<std::string>& xivaSubscriptions);

        ~PushdSocket();

        std::vector<std::string> getServiceNames() override;

        void sendBinaryData(const std::string& buffer,
                            FailCallback onFail = FailCallback()) override;

        void sendTextData(const std::string& buffer,
                          FailCallback onFail = FailCallback()) override;

    private:
        void handleQuasarMessage(const quasar::ipc::SharedMessage& message);

        void subscribeToExtraPushdData();

    private:
        const std::vector<std::string> xivaSubscriptions_;
        std::shared_ptr<quasar::ipc::IConnector> toPushd_;
    };

} // namespace messenger
