#pragma once

#include <yandex_io/callkit/util/cancelable.h>

#include <chrono>
#include <functional>
#include <map>
#include <memory>
#include <queue>
#include <set>
#include <string>

namespace messenger {

    namespace xiva {
        class Transport;
    } // namespace xiva
    class LoopThread;
    class XivaRequest;
    struct BaseRequestTask;

    // on: worker
    class RequestHandler: public std::enable_shared_from_this<RequestHandler> {
    public:
        RequestHandler(std::shared_ptr<LoopThread> workerThread,
                       std::shared_ptr<xiva::Transport> xivaTransport);
        virtual ~RequestHandler();
        Cancelable process(std::shared_ptr<BaseRequestTask> task);

        bool hasBgTasks() const;
        void runOnBgIdle(std::function<void()> callback);

        void stopAll();

    private:
        friend class XivaRequest;

        uint32_t startRequest(std::shared_ptr<XivaRequest> /*request*/);
        std::shared_ptr<XivaRequest> finishRequest(uint32_t requestId);
        void onRequestDone(uint32_t requestId);
        void onRequestRetry(uint32_t requestId, std::chrono::milliseconds delay);

        void cancelActiveRequests();
        void processIdleState();

        std::shared_ptr<LoopThread> workerThread_;
        std::shared_ptr<xiva::Transport> xivaTransport_;
        std::map<uint32_t /*requestId*/, std::shared_ptr<XivaRequest>> activeTasks_;
        std::set<std::shared_ptr<XivaRequest>> retryTasks_;
        std::queue<std::function<void()>> idleCallbacks_;
    };

} // namespace messenger
