#pragma once

#include <yandex_io/callkit/messenger_tool/commands/tool_processor.h>

#include <stdio.h>
#include <stdlib.h>
#include <streambuf>
#include <string>

namespace messenger {

    struct CliIO: public messenger::ToolProcessor::Printer {
        CliIO() {
            setbuf(stdout, nullptr);
        }
        void println(const std::string& str) override {
            writeCout("\33[2K\r");
            writeCout(str);
            writeCout("\n");
            if (input) {
                printPrompt();
            }
        }
        void printerrln(const std::string& str) override {
            writeErr("\33[2K\r");
            writeErr("\33[0;31m");
            writeErr(str);
            writeErr("\n");
            writeErr("\33[0m");
            if (input) {
                printPrompt();
            }
        }
        void printinfoln(const std::string& str) override {
            writeErr("\33[2K\r");
            writeErr("\33[0;34m");
            writeErr(str);
            writeErr("\n");
            writeErr("\33[0m");
            if (input) {
                printPrompt();
            }
        }
        void printwarnln(const std::string& str) override {
            writeErr("\33[2K\r");
            writeErr("\33[1;32m");
            writeErr(str);
            writeErr("\n");
            writeErr("\33[0m");
            if (input) {
                printPrompt();
            }
        }
        std::string getLine() {
            printPrompt();
            input = true;
            std::string line = readline();
            input = false;
            return line;
        }

    private:
        static void printPrompt() {
            writeCout("\33[2K\r$ ");
        }
        static std::string readline() {
            char* line = nullptr;
            size_t len = 0;
            ssize_t nread;
            std::string str;
            if ((nread = getline(&line, &len, stdin)) != -1) {
                if (nread > 0 && line[nread - 1] == '\n') {
                    nread--;
                }
                str = std::string(line, nread);
            }
            free(line);
            return str;
        }
        static void writeCout(const std::string& line) {
            printf("%s", line.data());
        }
        static void writeErr(const std::string& line) {
            fprintf(stderr, "%s", line.data());
        }
        bool input = false;
    };

} // namespace messenger
