#pragma once

#include "tool_processor.h"

#include <yandex_io/callkit/calls/call/status.h>
#include <yandex_io/callkit/session/session.h>
#include <yandex_io/callkit/util/loop_thread.h>
#include <yandex_io/callkit/util/observer_list.h>

#include <map>
#include <memory>
#include <mutex>
#include <string>

struct CommandData;

namespace messenger {

    class DirectToolProcessor: public ToolProcessor {
    public:
        DirectToolProcessor(std::shared_ptr<Printer> printer, std::shared_ptr<Session> session);

        ~DirectToolProcessor();

        void execute(const std::string& text) override;

    private:
        void watchStateChange();
        void processStateChange();
        void watchNewSession();

        void processCommandName(CommandData& command);
        void execute(CommandData& command);
        void checkConnected();
        void sleepSeconds(unsigned seconds);

        bool hasIncomingCall(Status passedStatus);
        bool hasIncomingCall(const Session::State& state, Status passedStatus = Status::NEW);
        bool hasOutgoingCall(Status passedStatus);
        bool hasOutgoingCall(const Session::State& state, Status passedStatus = Status::NEW);

        void outputWaiting(unsigned seconds);

        void exitScript(CommandData& command);
        void echo(CommandData& command);
        void sleep(CommandData& command);
        void sendHeartbeat(CommandData& command);
        void startCall(CommandData& command);
        void waitAnyCallRinging(CommandData& command);
        void waitIncomingCall(CommandData& command);
        void waitOutgoingCall(CommandData& command);
        void declineIncomingCall(CommandData& command);
        void acceptIncomingCall(CommandData& command);
        void hangupCall(CommandData& command);

        std::shared_ptr<LoopThread> thread_;
        std::string lastStateString_;

        std::shared_ptr<Session> session_;

        Session::StateChangedSubscription callStateSubscription_;
        CallbackSubscription callCreationFailedSubscription_;
        std::mutex sessionMutex_;

        std::map<std::string, std::string> aliases_;

        bool destroying_;
    };

} // namespace messenger
