#pragma once

#include <memory>
#include <string>

namespace messenger {

    class ToolProcessor {
    public:
        struct Printer {
            virtual void println(const std::string& /*line*/){};
            virtual void printerrln(const std::string& /*line*/){};
            virtual void printinfoln(const std::string& /*line*/){};
            virtual void printwarnln(const std::string& /*line*/){};
            virtual ~Printer() = default;
        };

        ToolProcessor(std::shared_ptr<Printer> printer);
        virtual ~ToolProcessor();

        virtual void execute(const std::string& commands) = 0;

    protected:
        std::shared_ptr<Printer> printer_;
    };

} // namespace messenger
