#pragma once

#include <yandex_io/libs/bluetooth/bluetooth_capabilities_impl.h>
#include <yandex_io/libs/hal/hal.h>

using namespace quasar;

class HALStub: public YandexIO::HAL {
    std::optional<YandexIO::HALInfo> getHALInfo() override {
        return std::nullopt;
    }

    std::shared_ptr<BluetoothLE> createBluetoothLE() override {
        return nullptr;
    }

    std::unique_ptr<YandexIO::DeviceCryptography>
    createDeviceCryptography(const Json::Value& /*config*/) override {
        return nullptr;
    }

    quasar::BluetoothCapabilities& getBluetoothCapabilities() override {
        static BluetoothCapabilitiesImpl singleton(/*streamIn*/ false,
                                                   /*streamOut*/ false,
                                                   /*ble*/ false);
        return singleton;
    }

    std::shared_ptr<YandexIO::IIotDiscoveryProvider> createIotDiscoveryProvider() override {
        return nullptr;
    }
};
