#include "cli_io.h"
#include "hal_stub.h"

#include <yandex_io/callkit/messenger_tool/commands/direct_tool_processor.h>

#include <yandex_io/callkit/cli/cli.h>
#include <yandex_io/callkit/session/session.h>
#include <yandex_io/callkit/session/session_provider.h>

#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/json_utils/json_utils.h>
#include <yandex_io/libs/logging/setup/setup.h>
#include <yandex_io/libs/telemetry/null/null_metrica.h>

#include <json/json.h>

#include <util/generic/size_literals.h>

#include <chrono>
#include <fstream>
#include <future>
#include <iostream>
#include <memory>
#include <stdexcept>
#include <string>
#include <thread>

#include <sys/stat.h>

namespace {

    std::shared_ptr<YandexIO::Device> makeDevice() {
        auto configuration = YandexIO::makeConfiguration();
        auto telemetry = std::unique_ptr<YandexIO::ITelemetry>(new NullMetrica());
        auto hal = std::unique_ptr<YandexIO::HAL>(new HALStub());
        return std::make_unique<YandexIO::Device>(
            "messenger_tool_fake_id", std::move(configuration),
            std::move(telemetry), std::move(hal));
    }

    std::string getAppPath() {
        char path[1024];
        int size;
        if ((size = readlink("/proc/self/exe", path, 1023)) != -1) {
            path[size] = 0;
            return std::string(path);
        }
        Y_VERIFY(!"No path");
        return "";
    }

} // namespace

int main(int n, char** args) {
    auto execPath = getAppPath();
    auto execName = quasar::getFileName(execPath);

    if (n < 4) {
        std::cerr << "usage: messenger_tool <passportUid> <authToken> <server> args..." << std::endl;
        return 1;
    }

    const std::string passportUid(args[1]);
    const std::string authToken(args[2]);
    const std::string server(args[3]);

    if (passportUid.empty()) {
        std::cerr << "Uid must not be empty" << std::endl;
        return 1;
    }

    if (authToken.empty()) {
        std::cerr << "Token must not be empty" << std::endl;
        return 1;
    }

    if (server == "custom") {
        std::cerr << "Custom server is not supported" << std::endl;
        return 1;
    }

    auto device = makeDevice();

    quasar::Logging::initLoggingToFile("/data/quasar/daemons_logs/" + execName + ".log", "debug", 10_KB, 1);

    std::vector<std::string> xivaSubscriptions;
    try {
        xivaSubscriptions = messenger::SessionProvider::getXivaServices(nullptr);

    } catch (const std::runtime_error& e) {
    }

    messenger::SessionProvider provider(nullptr, device, "messenger_util", "Debug tool for calls", "0.1", passportUid, authToken, xivaSubscriptions);

    return messenger::cli(provider.createCustomSession(passportUid, authToken, server, true, "", ""), n, args);
}
