#pragma once

#include <yandex_io/callkit/rtc/media/entities.h>
#include <yandex_io/callkit/rtc/media/transport.h>

#include <yandex_io/callkit/util/loop_thread.h>
#include <yandex_io/callkit/util/observer_list.h>

#include <yandex_io/libs/json_utils/json_utils.h>

#include <memory>

namespace messenger {
    namespace rtc {

        // on: worker
        class MediatorApi: public Transport::Listener {
        public:
            static std::shared_ptr<MediatorApi> create(
                std::shared_ptr<Transport> transport,
                std::shared_ptr<LoopThread> workerThread);

            // Do not use this constructor. Use static create method instead.
            MediatorApi(
                std::shared_ptr<Transport> transport,
                std::shared_ptr<LoopThread> workerThread);

        public:
            // Receive

            using Message = Json::Value;

            using MessageObserver = std::function<void(const Message&)>;

            using MessageSubscription = ObserverList<const Message&>::ScopedSubscription;

            MessageSubscription subscribe(MessageObserver observer);

        public:
            // Send error types

            enum class ErrorType {
                INVALID_OFFER,
                INVALID_ANSWER,
                ADD_CANDIDATE_FAILED,
                REMOVE_CANDIDATES_FAILED,
                CLIENT_ERROR
            };

        public:
            // Send

            std::string retrieveIceServersConfig(const std::string& guid);

            std::string offer(const std::string& guid, const std::string& offer);

            std::string answer(const std::string& guid, const std::string& answer);

            std::string addCandidates(const std::string& guid, const std::vector<IceCandidate>& candidates);

            std::string removeCandidates(const std::string& guid, const std::vector<IceCandidate>& candidates);

            std::string acknowledge(const std::string& guid, const std::string& requestId);

            std::string updateMediaState(const std::string& guid, bool sendAudio, bool sendVideo);

            std::string keepAlive(const std::string& guid, const Json::Value& statsReport);

            std::string reportError(const std::string& guid, const std::string& message, ErrorType type);

            std::string reportEvent(const std::string& guid, const Json::Value& event);

            void returnError(
                const std::string& guid,
                const std::string& requestId,
                const std::string& message,
                const Json::Value& detail,
                ErrorType type);

        public:
            // Transport::Listener impl

            void onMessage(const Transport::Message& msg) override;

        private:
            using MediatorRequest = Json::Value;

            static MediatorRequest makeRequest(const std::string& id, const std::string& method);

            void send(const MediatorRequest& request);

        private:
            std::shared_ptr<Transport> transport_;

            std::shared_ptr<LoopThread> workerThread_;

            ObserverList<const Message&> observerList_;
        };

    } // namespace rtc
} // namespace messenger
