#pragma once

#include "api/mediator_api.h"

namespace messenger {
    namespace rtc {

        class CandidatesSender {
        public:
            virtual ~CandidatesSender() = default;

            virtual void addCandidate(const IceCandidate& candidate) = 0;

            virtual void removeCandidates(const std::vector<IceCandidate>& candidates) = 0;

            virtual void completeTrickling() = 0;

            virtual void reset() = 0;

            virtual void start() = 0;
        };

        std::shared_ptr<CandidatesSender> createCandidatesSender(
            const std::string& sessionUuid,
            std::shared_ptr<MediatorApi> mediator,
            std::shared_ptr<LoopThread> workerThread);

    } // namespace rtc
} // namespace messenger
