#include "device_info.h"

#include <yandex_io/libs/json_utils/json_utils.h>

using namespace messenger::rtc;

DeviceInfo::DeviceInfo() {
    json_ = quasar::parseJson("{ \
        \"device_info\": { \
            \"protocol_version\": 2, \
            \"app_id\": \"\", \
            \"app_name\": \"\", \
            \"app_version\": \"\", \
            \"platform\": \"QUASAR\", \
            \"device_type\": \"SMART_SPEAKER\", \
            \"os_version\": \"\", \
            \"quasar\": { \
                \"device_manufacturer\": \"\", \
                \"device_type\": \"\", \
                \"device_id\": \"\", \
                \"device_os\": \"\", \
                \"software_version\": \"\" \
            }, \
            \"network_type\": \"WIFI\", \
            \"supported_encoders\": [], \
            \"supported_decoders\": [], \
            \"capabilities\": { \
                \"sdp_semantics\": [ \
                    \"plan-b\", \
                    \"unified-plan\" \
                ] \
            } \
        }, \
        \"debug_options\": {}, \
        \"payload\": \"\" \
    }");
}

DeviceInfo::~DeviceInfo() = default;

DeviceInfo* DeviceInfo::setAppId(const std::string& appId) {
    return setCommonOption("app_id", appId);
}

DeviceInfo* DeviceInfo::setAppName(const std::string& appName) {
    return setCommonOption("app_name", appName);
}

DeviceInfo* DeviceInfo::setAppVersion(const std::string& appVersion) {
    return setCommonOption("app_version", appVersion);
}

DeviceInfo* DeviceInfo::setOsVersion(const std::string& osVersion) {
    return setCommonOption("os_version", osVersion);
}

DeviceInfo*
DeviceInfo::setDeviceManufacturer(const std::string& deviceManufacturer) {
    return setPlatformOption("device_manufacturer", deviceManufacturer);
}

DeviceInfo* DeviceInfo::setDeviceType(const std::string& deviceType) {
    return setPlatformOption("device_type", deviceType);
}

DeviceInfo* DeviceInfo::setDeviceId(const std::string& deviceId) {
    return setPlatformOption("device_id", deviceId);
}

DeviceInfo* DeviceInfo::setDeviceOs(const std::string& deviceOs) {
    return setPlatformOption("device_os", deviceOs);
}

DeviceInfo* DeviceInfo::setDeviceGroup(const std::string& deviceGroup) {
    return setPlatformOption("device_group", deviceGroup);
}

DeviceInfo* DeviceInfo::setSoftwareVersion(const std::string& softwareVersion) {
    return setPlatformOption("software_version", softwareVersion);
}

DeviceInfo* DeviceInfo::setDebugOption(const std::string& key,
                                       Json::Value value) {
    Y_VERIFY(json_.isMember("device_info"));
    Y_VERIFY(json_["device_info"].isMember("debug_options"));
    json_["debug_options"][key] = value;
    return this;
}

DeviceInfo* DeviceInfo::setCustomPayload(const std::string& payload) {
    Y_VERIFY(json_.isMember("payload"));
    json_["payload"] = payload;
    return this;
}

std::string DeviceInfo::payload() {
    return quasar::jsonToString(json_);
}

DeviceInfo* DeviceInfo::setCommonOption(const char* key,
                                        const std::string& value) {
    Y_VERIFY(json_.isMember("device_info"));
    Y_VERIFY(json_["device_info"].isMember(key));
    json_["device_info"][key] = value;
    return this;
}

DeviceInfo* DeviceInfo::setPlatformOption(const char* key,
                                          const std::string& value) {
    Y_VERIFY(json_.isMember("device_info"));
    Y_VERIFY(json_["device_info"].isMember("quasar"));
    Y_VERIFY(json_["device_info"]["quasar"].isMember(key));
    json_["device_info"]["quasar"][key] = value;
    return this;
}
