#pragma once

#include <json/value.h>

#include <memory>
#include <string>

namespace messenger {
    namespace rtc {

        class DeviceInfo {
        public:
            DeviceInfo();
            DeviceInfo(const DeviceInfo& other) = default;
            virtual ~DeviceInfo();

            DeviceInfo* setAppId(const std::string& appId);
            DeviceInfo* setAppName(const std::string& appName);
            DeviceInfo* setAppVersion(const std::string& appVersion);
            DeviceInfo* setOsVersion(const std::string& osVersion);
            DeviceInfo* setDeviceManufacturer(const std::string& deviceManufacturer);
            DeviceInfo* setDeviceType(const std::string& deviceType);
            DeviceInfo* setDeviceId(const std::string& deviceId);
            DeviceInfo* setDeviceOs(const std::string& deviceOs);
            DeviceInfo* setDeviceGroup(const std::string& deviceGroup);
            DeviceInfo* setSoftwareVersion(const std::string& softwareVersion);
            DeviceInfo* setDebugOption(const std::string& key, Json::Value value);
            DeviceInfo* setCustomPayload(const std::string& payload);

            std::string payload();

        private:
            DeviceInfo* setCommonOption(const char* key, const std::string& value);
            DeviceInfo* setPlatformOption(const char* key, const std::string& value);

            Json::Value json_;
        };

    } // namespace rtc
} // namespace messenger
