#pragma once

#include <boost/functional/hash.hpp>

#include <string>

namespace messenger {
    namespace rtc {

        struct IceCandidate {
            IceCandidate() = default;

            std::string mId;
            int mLineIndex = 0;
            std::string candidate;

            struct Hash {
                size_t operator()(const IceCandidate& x) const {
                    size_t seed = 0;
                    boost::hash_combine(seed, x.mId);
                    boost::hash_combine(seed, x.mLineIndex);
                    boost::hash_combine(seed, x.candidate);
                    return seed;
                }
            };

            bool operator==(const IceCandidate& x) const {
                return mId == x.mId && mLineIndex == x.mLineIndex && candidate == x.candidate;
            }
        };

    } // namespace rtc
} // namespace messenger
