#include "fake_web_rtc_video_engine.h"

#include <contrib/libs/webrtc/media/base/codec.h>
#include <contrib/libs/webrtc/modules/video_coding/include/video_error_codes.h>

using namespace messenger::rtc;

namespace {

    bool IsFormatSupported(
        const std::vector<webrtc::SdpVideoFormat>& supportedFormats,
        const webrtc::SdpVideoFormat& format) {
        for (const webrtc::SdpVideoFormat& supportedFormat : supportedFormats) {
            if (cricket::IsSameCodec(format.name, format.parameters,
                                     supportedFormat.name,
                                     supportedFormat.parameters)) {
                return true;
            }
        }

        return false;
    }

} // namespace

int32_t FakeWebRtcVideoDecoder::InitDecode(const webrtc::VideoCodec* /*codec_settings*/, int32_t /*number_of_cores*/) {
    return WEBRTC_VIDEO_CODEC_OK;
}

int32_t FakeWebRtcVideoDecoder::Decode(const webrtc::EncodedImage& /*input_image*/, bool /*missing_frames*/,
                                       int64_t /*render_time_ms*/) {
    return WEBRTC_VIDEO_CODEC_OK;
}

int32_t FakeWebRtcVideoDecoder::RegisterDecodeCompleteCallback(
    webrtc::DecodedImageCallback* /*callback*/) {
    return WEBRTC_VIDEO_CODEC_OK;
}

int32_t FakeWebRtcVideoDecoder::Release() {
    return WEBRTC_VIDEO_CODEC_OK;
}

std::vector<webrtc::SdpVideoFormat>
FakeWebRtcVideoDecoderFactory::GetSupportedFormats() const {
    std::vector<webrtc::SdpVideoFormat> formats;

    for (const webrtc::SdpVideoFormat& format : formats_) {
        if (!IsFormatSupported(formats, format)) {
            formats.push_back(format);
        }
    }

    return formats;
}

std::unique_ptr<webrtc::VideoDecoder>
FakeWebRtcVideoDecoderFactory::CreateVideoDecoder(
    const webrtc::SdpVideoFormat& format) {
    if (IsFormatSupported(formats_, format)) {
        return std::unique_ptr<webrtc::VideoDecoder>(
            new FakeWebRtcVideoDecoder());
    }

    return nullptr;
}

void FakeWebRtcVideoDecoderFactory::AddSupportedVideoCodecType(
    const std::string& name) {
    cricket::VideoCodec videoCodec(name);
    formats_.push_back(
        webrtc::SdpVideoFormat(videoCodec.name, videoCodec.params));
}

void FakeWebRtcVideoEncoder::SetFecControllerOverride(
    webrtc::FecControllerOverride* /*fec_controller_override*/) {
}

int32_t FakeWebRtcVideoEncoder::InitEncode(const webrtc::VideoCodec* /*codec_settings*/,
                                           const VideoEncoder::Settings& /*settings*/) {
    return WEBRTC_VIDEO_CODEC_OK;
}

int32_t
FakeWebRtcVideoEncoder::Encode(const webrtc::VideoFrame& /*frame*/,
                               const std::vector<webrtc::VideoFrameType>* /*frame_types*/) {
    return WEBRTC_VIDEO_CODEC_OK;
}

int32_t FakeWebRtcVideoEncoder::RegisterEncodeCompleteCallback(
    webrtc::EncodedImageCallback* /*callback*/) {
    return WEBRTC_VIDEO_CODEC_OK;
}

int32_t FakeWebRtcVideoEncoder::Release() {
    return WEBRTC_VIDEO_CODEC_OK;
}

void FakeWebRtcVideoEncoder::SetRates(const RateControlParameters& /*parameters*/) {
}

webrtc::VideoEncoder::EncoderInfo
FakeWebRtcVideoEncoder::GetEncoderInfo() const {
    EncoderInfo info;
    info.is_hardware_accelerated = true;
    info.has_internal_source = false;
    return info;
}

std::vector<webrtc::SdpVideoFormat>
FakeWebRtcVideoEncoderFactory::GetSupportedFormats() const {
    std::vector<webrtc::SdpVideoFormat> formats;

    for (const webrtc::SdpVideoFormat& format : formats_) {
        if (!IsFormatSupported(formats, format)) {
            formats.push_back(format);
        }
    }

    return formats;
}

std::unique_ptr<webrtc::VideoEncoder>
FakeWebRtcVideoEncoderFactory::CreateVideoEncoder(
    const webrtc::SdpVideoFormat& format) {
    if (IsFormatSupported(formats_, format)) {
        return std::unique_ptr<webrtc::VideoEncoder>(
            new FakeWebRtcVideoEncoder());
    }

    return nullptr;
}

webrtc::VideoEncoderFactory::CodecInfo
FakeWebRtcVideoEncoderFactory::QueryVideoEncoder(
    const webrtc::SdpVideoFormat& format) const {
    webrtc::VideoEncoderFactory::CodecInfo info;
    info.has_internal_source = false;
    info.is_hardware_accelerated = true;
    return info;
}

void FakeWebRtcVideoEncoderFactory::AddSupportedVideoCodecType(
    const std::string& name) {
    cricket::VideoCodec videoCodec(name);
    formats_.push_back(
        webrtc::SdpVideoFormat(videoCodec.name, videoCodec.params));
}
