#pragma once

#include <contrib/libs/webrtc/api/video_codecs/video_decoder.h>
#include <contrib/libs/webrtc/api/video_codecs/video_decoder_factory.h>
#include <contrib/libs/webrtc/api/video_codecs/video_encoder.h>
#include <contrib/libs/webrtc/api/video_codecs/video_encoder_factory.h>

namespace messenger {
    namespace rtc {

        class FakeWebRtcVideoDecoder: public webrtc::VideoDecoder {
        public:
            int32_t InitDecode(const webrtc::VideoCodec* /*codec_settings*/, int32_t /*number_of_cores*/) override;

            int32_t Decode(const webrtc::EncodedImage& /*input_image*/, bool /*missing_frames*/, int64_t /*render_time_ms*/) override;

            int32_t RegisterDecodeCompleteCallback(webrtc::DecodedImageCallback* /*callback*/) override;

            int32_t Release() override;
        };

        class FakeWebRtcVideoDecoderFactory: public webrtc::VideoDecoderFactory {
        public:
            std::vector<webrtc::SdpVideoFormat> GetSupportedFormats() const override;

            std::unique_ptr<webrtc::VideoDecoder> CreateVideoDecoder(const webrtc::SdpVideoFormat& format) override;

            void AddSupportedVideoCodecType(const std::string& name);

        private:
            std::vector<webrtc::SdpVideoFormat> formats_;
        };

        class FakeWebRtcVideoEncoder: public webrtc::VideoEncoder {
        public:
            void SetFecControllerOverride(webrtc::FecControllerOverride* fec_controller_override) override;

            int32_t InitEncode(const webrtc::VideoCodec* codecSettings, const VideoEncoder::Settings& settings) override;

            int32_t Encode(const webrtc::VideoFrame& inputImage, const std::vector<webrtc::VideoFrameType>* frameTypes) override;

            int32_t RegisterEncodeCompleteCallback(webrtc::EncodedImageCallback* callback) override;

            int32_t Release() override;

            void SetRates(const RateControlParameters& parameters) override;

            webrtc::VideoEncoder::EncoderInfo GetEncoderInfo() const override;
        };

        class FakeWebRtcVideoEncoderFactory: public webrtc::VideoEncoderFactory {
        public:
            std::vector<webrtc::SdpVideoFormat> GetSupportedFormats() const override;

            std::unique_ptr<webrtc::VideoEncoder> CreateVideoEncoder(const webrtc::SdpVideoFormat& format) override;

            CodecInfo QueryVideoEncoder(const webrtc::SdpVideoFormat& format) const override;

            void AddSupportedVideoCodecType(const std::string& name);

        private:
            std::vector<webrtc::SdpVideoFormat> formats_;
        };

    } // namespace rtc
} // namespace messenger
