#include "media_session.h"

#include "media_session_impl.h"
#include "api/mediator_api.h"

#include <yandex_io/callkit/rtc/utils/network_monitor.h>
#include <yandex_io/callkit/rtc/utils/timer_factory.h>
#include <yandex_io/callkit/rtc/utils/utils.h>

#include <yandex_io/libs/base/utils.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>

using namespace messenger::rtc;

std::shared_ptr<MediaSession> messenger::rtc::createMediaSession(
    const std::shared_ptr<quasar::ipc::IIpcFactory>& ipcFactory,
    const std::string& callGuid,
    std::shared_ptr<Transport> transport,
    std::shared_ptr<LoopThread> workerThread,
    std::shared_ptr<DeviceInfo> deviceInfo,
    std::shared_ptr<quasar::IUserConfigProvider> userConfigProvider,
    Json::Value callsConfig)
{
    const auto genCallGuid = callGuid.empty() ? quasar::makeUUID() : callGuid;
    const auto direction = callGuid.empty() ? Direction::OUTGOING : Direction::INCOMING;
    const auto timerFactory = std::make_shared<TimerFactory>(workerThread);
    const auto mediatorApi = MediatorApi::create(transport, workerThread);

    YIO_LOG_INFO("create()");

    return std::make_shared<MediaSessionImpl>(
        ipcFactory,
        genCallGuid,
        mediatorApi,
        deviceInfo,
        workerThread,
        timerFactory,
        direction,
        std::move(userConfigProvider),
        std::move(callsConfig));
}

template <>
std::string messenger::rtc::toString(const MediaSession::Status& obj) {
    switch (obj) {
        case MediaSession::Status::DISCONNECTED:
            return "DISCONNECTED";

        case MediaSession::Status::CONNECTING:
            return "CONNECTING";

        case MediaSession::Status::CONNECTED:
            return "CONNECTED";

        case MediaSession::Status::RECONNECTING:
            return "RECONNECTING";

        case MediaSession::Status::DISCONNECTING:
            return "DISCONNECTING";

        case MediaSession::Status::DISPOSED:
            return "DISPOSED";

        default:
            // Should never happen
            return "N/A";
    }
}
