#pragma once

#include "device_info.h"
#include "direction.h"
#include "transport.h"

#include <yandex_io/callkit/util/loop_thread.h>
#include <yandex_io/callkit/util/observer_list.h>

#include <yandex_io/interfaces/user_config/i_user_config_provider.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>

#include <json/json.h>

#include <functional>
#include <memory>
#include <string>

namespace messenger {
    namespace rtc {

        // on: worker thread
        class MediaSession {
        public:
            enum class Status {
                CONNECTING,
                CONNECTED,
                RECONNECTING,
                DISCONNECTING,
                DISCONNECTED,
                DISPOSED,
            };

            using StatusObserver = std::function<void(Status)>;
            using StatusSubscription = ObserverList<Status>::ScopedSubscription;
            using FailureObserver = std::function<void(const std::string&)>;
            using FailureSubscription = ObserverList<const std::string&>::ScopedSubscription;

        public:
            virtual ~MediaSession() = default;

            virtual std::string getCallGuid() const = 0;

            virtual std::shared_ptr<const DeviceInfo> getDeviceInfo() const = 0;

            virtual Direction getDirection() const = 0;

            virtual Status getStatus() const = 0;

            virtual void dispose() = 0;

            virtual StatusSubscription subscribeStatus(StatusObserver observer) = 0;

            virtual FailureSubscription subscribeFailure(FailureObserver observer) = 0;
        };

        std::shared_ptr<MediaSession> createMediaSession(
            const std::shared_ptr<quasar::ipc::IIpcFactory>& ipcFactory,
            const std::string& callGuid,
            std::shared_ptr<Transport> transport,
            std::shared_ptr<LoopThread> workerThread,
            std::shared_ptr<DeviceInfo> deviceInfo,
            std::shared_ptr<quasar::IUserConfigProvider> userConfigProvider,
            Json::Value callsConfig);

    } // namespace rtc
} // namespace messenger
