#include "media_session_factory.h"

using namespace messenger::rtc;

MediaSessionFactory::MediaSessionFactory(
    std::shared_ptr<quasar::ipc::IIpcFactory> ipcFactory,
    std::shared_ptr<quasar::IUserConfigProvider> userConfigProvider,
    Json::Value callsConfig)
    : callsConfig_((std::move(callsConfig)))
    , ipcFactory_(ipcFactory)
    , userConfigProvider_(std::move(userConfigProvider))
{
}

std::shared_ptr<MediaSession>
MediaSessionFactory::create(std::shared_ptr<Transport> transport,
                            std::shared_ptr<LoopThread> workerThread,
                            std::shared_ptr<DeviceInfo> deviceInfo,
                            const std::string& callGuid) {
    return createMediaSession(ipcFactory_, callGuid, transport, workerThread, deviceInfo, userConfigProvider_, callsConfig_);
}
