#pragma once

#include "media_session.h"

#include <yandex_io/interfaces/user_config/i_user_config_provider.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>

#include <json/json.h>

#include <memory>
#include <string>

namespace messenger {
    namespace rtc {

        class MediaSessionFactory {
        public:
            MediaSessionFactory(
                std::shared_ptr<quasar::ipc::IIpcFactory> ipcFactory,
                std::shared_ptr<quasar::IUserConfigProvider> userConfigProvider,
                Json::Value callsConfig);

            std::shared_ptr<MediaSession> create(
                std::shared_ptr<Transport> transport,
                std::shared_ptr<LoopThread> workerThread,
                std::shared_ptr<DeviceInfo> deviceInfo,
                const std::string& callGuid);

        private:
            const Json::Value callsConfig_;
            std::shared_ptr<quasar::ipc::IIpcFactory> ipcFactory_;
            std::shared_ptr<quasar::IUserConfigProvider> userConfigProvider_;
        };

    } // namespace rtc
} // namespace messenger
