#include "media_session_impl.h"

#include <yandex_io/callkit/util/loop_thread.h>

#include <util/system/yassert.h>

using namespace messenger::rtc;

MediaSessionImpl::MediaSessionImpl(
    const std::shared_ptr<quasar::ipc::IIpcFactory>& ipcFactory,
    const std::string& callGuid,
    std::shared_ptr<MediatorApi> mediatorApi,
    std::shared_ptr<DeviceInfo> deviceInfo,
    std::shared_ptr<LoopThread> workerThread,
    std::shared_ptr<TimerFactory> timerFactory,
    Direction direction,
    std::shared_ptr<quasar::IUserConfigProvider> userConfigProvider,
    Json::Value calldConfig)
    : callGuid_(callGuid)
    , mediatorApi_(std::move(mediatorApi))
    , deviceInfo_(std::move(deviceInfo))
    , workerThread_(std::move(workerThread))
    , timerFactory_(std::move(timerFactory))
    , direction_(direction)
    , machine_(new SessionStateMachine(ipcFactory, direction_, callGuid_, mediatorApi_, workerThread_, timerFactory_, std::move(userConfigProvider), std::move(calldConfig)))
{
    machine_->setListener(this);
}

MediaSessionImpl::~MediaSessionImpl() {
}

void MediaSessionImpl::ensureOnWorkerThread() const {
    Y_VERIFY(workerThread_->checkInside());
}

std::string MediaSessionImpl::getCallGuid() const {
    return callGuid_;
}

std::shared_ptr<const DeviceInfo> MediaSessionImpl::getDeviceInfo() const {
    return deviceInfo_;
}

Direction MediaSessionImpl::getDirection() const {
    return direction_;
}

MediaSession::Status MediaSessionImpl::getStatus() const {
    ensureOnWorkerThread();

    return machine_->getStatus();
}

void MediaSessionImpl::dispose() {
}

MediaSession::StatusSubscription MediaSessionImpl::subscribeStatus(MediaSession::StatusObserver observer) {
    return statusObserverList_.subscribe(std::move(observer));
}

MediaSession::FailureSubscription MediaSessionImpl::subscribeFailure(MediaSession::FailureObserver observer) {
    return failureObserverList_.subscribe(std::move(observer));
}

void MediaSessionImpl::onStatusChanged(MediaSession::Status status) {
    statusObserverList_.notifyObservers(status);
}

void MediaSessionImpl::onFailure(const std::string& errorMessage) {
    failureObserverList_.notifyObservers(errorMessage);
}
