#pragma once

#include "media_session.h"
#include "session_state_machine.h"

#include <yandex_io/interfaces/user_config/i_user_config_provider.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>

#include <json/json.h>

namespace messenger {

    class LoopThread;

    namespace rtc {

        class MediaSessionImpl: public MediaSession,
                                public SessionStateMachine::Listener {
        public:
            MediaSessionImpl(const std::shared_ptr<quasar::ipc::IIpcFactory>& ipcFactory,
                             const std::string& callGuid,
                             std::shared_ptr<MediatorApi> mediatorApi,
                             std::shared_ptr<DeviceInfo> deviceInfo,
                             std::shared_ptr<LoopThread> workerThread,
                             std::shared_ptr<TimerFactory> timerFactory,
                             Direction direction,
                             std::shared_ptr<quasar::IUserConfigProvider> userConfigProvider,
                             Json::Value calldConfig);

            ~MediaSessionImpl();

        public:
            // MediaSession impl

            std::string getCallGuid() const override;

            std::shared_ptr<const DeviceInfo> getDeviceInfo() const override;

            Direction getDirection() const override;

            Status getStatus() const override;

            void dispose() override;

            StatusSubscription subscribeStatus(StatusObserver observer) override;

            FailureSubscription subscribeFailure(FailureObserver observer) override;

        public:
            // SessionStateMachine::Listener impl

            void onStatusChanged(MediaSession::Status status) override;

            void onFailure(const std::string& errorMessage) override;

        private:
            void ensureOnWorkerThread() const;

        private:
            const std::string callGuid_;
            std::shared_ptr<MediatorApi> mediatorApi_;
            std::shared_ptr<DeviceInfo> deviceInfo_;
            std::shared_ptr<LoopThread> workerThread_;
            std::shared_ptr<TimerFactory> timerFactory_;
            const Direction direction_;

            ObserverList<MediaSession::Status> statusObserverList_;
            ObserverList<const std::string&> failureObserverList_;

            std::unique_ptr<SessionStateMachine> machine_;
        };

    } // namespace rtc
} // namespace messenger
