#pragma once

#include <yandex_io/callkit/util/loop_thread.h>

#include <contrib/libs/webrtc/api/peer_connection_interface.h>

#include <unordered_set>

namespace messenger {
    namespace rtc {

        class RedirectPeerConnectionObserver
            : public webrtc::PeerConnectionObserver,
              public std::enable_shared_from_this<RedirectPeerConnectionObserver> {
        public:
            explicit RedirectPeerConnectionObserver(
                std::shared_ptr<LoopThread> workerThread);

            ~RedirectPeerConnectionObserver();

            void subscribe(webrtc::PeerConnectionObserver* observer);

            void unsubscribe(webrtc::PeerConnectionObserver* observer);

        public:
            // PeerConnectionObserver

            void OnSignalingChange(
                webrtc::PeerConnectionInterface::SignalingState newState) override;

            void OnIceConnectionChange(
                webrtc::PeerConnectionInterface::IceConnectionState newState) override;

            void OnConnectionChange(
                webrtc::PeerConnectionInterface::PeerConnectionState newState) override;

            void OnIceConnectionReceivingChange(bool receiving) override;

            void OnIceGatheringChange(
                webrtc::PeerConnectionInterface::IceGatheringState newState) override;

            void
            OnIceCandidate(const webrtc::IceCandidateInterface* candidate) override;

            void OnIceCandidatesRemoved(
                const std::vector<cricket::Candidate>& candidates) override;

            void OnAddStream(
                ::rtc::scoped_refptr<webrtc::MediaStreamInterface> stream) override;

            void OnRemoveStream(
                ::rtc::scoped_refptr<webrtc::MediaStreamInterface> stream) override;

            void OnDataChannel(::rtc::scoped_refptr<webrtc::DataChannelInterface>
                                   dataChannel) override;

            void OnRenegotiationNeeded() override;

            void OnAddTrack(
                ::rtc::scoped_refptr<webrtc::RtpReceiverInterface> receiver,
                const std::vector<::rtc::scoped_refptr<webrtc::MediaStreamInterface>>&
                    streams) override;

            void OnTrack(::rtc::scoped_refptr<webrtc::RtpTransceiverInterface>
                             transceiver) override;

        private:
            std::weak_ptr<RedirectPeerConnectionObserver> weakFromThis();

            void ensureOnWorkerThread();

        private:
            std::shared_ptr<LoopThread> workerThread_;

            // Worker thread field
            std::unordered_set<webrtc::PeerConnectionObserver*> observers_;
        };

    } // namespace rtc
} // namespace messenger
