#pragma once

#include "candidates_sender.h"
#include "state_machine.h"
#include "api/mediator_api.h"

#include <list>

namespace messenger {

    class LoopThread;

    namespace rtc {

        class SenderStateMachine: public StateMachine, public CandidatesSender {
        public:
            SenderStateMachine(const std::string& sessionUuid,
                               std::shared_ptr<MediatorApi> mediator,
                               std::shared_ptr<LoopThread> workerThread);

            ~SenderStateMachine();

            void addCandidate(const IceCandidate& candidate) override;

            void removeCandidates(const std::vector<IceCandidate>& candidates) override;

            void completeTrickling() override;

            void reset() override;

            void start() override;

        public:
            class SenderState: public StateMachine::State {
            public:
                SenderState(SenderStateMachine* machine);

            protected:
                SenderStateMachine* machine_;
            };

            class WaitingForCandidatesState;
            class CandidatesSendingState;
            class CompleteSendingState;
            class CompleteSentState;

        private:
            enum class Operation { ADD,
                                   REMOVE };

        private:
            void onStateChange(State* oldState, State* newState) override;

        private:
            void removeSentCandidates(Operation operation,
                                      const std::vector<IceCandidate>& candidates);
            void ensureOnWorkerThread() const;
            void trySend();
            void tryComplete();

        private:
            const std::string sessionUuid_;
            std::shared_ptr<MediatorApi> mediator_;
            std::shared_ptr<LoopThread> workerThread_;

            std::list<std::pair<IceCandidate, Operation>> unsentCandidates_;

            bool gatheringCompleted_;
        };

    } // namespace rtc
} // namespace messenger
