#pragma once
#include "candidates_sender.h"
#include "direction.h"
#include "entities.h"
#include "media_session.h"
#include "redirect_peer_connection_observer.h"
#include "state_machine.h"
#include "stats_sender.h"
#include "api/mediator_api.h"

#include <yandex_io/callkit/rtc/media/audio_device_module/quasar_audio_device_module.h>

#include <yandex_io/callkit/rtc/utils/timer_factory.h>

#include <yandex_io/interfaces/user_config/i_user_config_provider.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>

#include <contrib/libs/webrtc/api/peer_connection_interface.h>

#include <json/json.h>

namespace messenger {

    class LoopThread;

    namespace rtc {

        class SessionStateMachine: public StateMachine {
        public:
            SessionStateMachine(const std::shared_ptr<quasar::ipc::IIpcFactory>& ipcFactory,
                                Direction direction,
                                const std::string& sessionUuid,
                                std::shared_ptr<MediatorApi> mediator,
                                std::shared_ptr<LoopThread> workerThread,
                                std::shared_ptr<TimerFactory> timerFactory,
                                std::shared_ptr<quasar::IUserConfigProvider> userConfigProvider,
                                Json::Value callsConfig);

            ~SessionStateMachine();

        public:
            class Listener {
            public:
                virtual ~Listener() = default;

                virtual void onStatusChanged(MediaSession::Status status) = 0;

                virtual void onFailure(const std::string& errorMessage) = 0;
            };

            void setListener(Listener* listener);

            MediaSession::Status getStatus() const;

        public:
            class SessionState: public StateMachine::State {
            public:
                SessionState(SessionStateMachine* machine);

            protected:
                SessionStateMachine* machine_;
            };

            // Before negotiation
            class ConfigAwaitingState;
            class ConfigApplyingState;
            class PeerConnectionCreatingState;
            class PeerConnectionCreatingFailedState;
            class UserMediaAcquiringState;
            class ReadyForNegotiationState;

            // Negotiation
            class NegotiatingState;
            class LocalOfferCreatingState;
            class LocalOfferSettingState;
            class LocalOfferSendingState;
            class RemoteAnswerReceivingState;
            class RemoteAnswerSettingState;
            class RemoteOfferReceivingState;
            class RemoteOfferSettingState;
            class LocalAnswerCreatingState;
            class LocalAnswerSettingState;
            class LocalAnswerSendingState;

            // Renegotiation
            class RenegotiationNeededState;

            // After negotiation
            class WaitingForConnectionState;
            class PeerConnectionEstablishedState;
            class PeerConnectionBrokenState;
            class PeerConnectionCreationFailedState;
            class SessionDisposedState;

        private:
            void onStateChange(State* oldState, State* newState) override;

        private:
            void subscribe(webrtc::PeerConnectionObserver* observer);

            void unsubscribe(webrtc::PeerConnectionObserver* observer);

            void notifyStatusChange(MediaSession::Status status);

            void notifyFailure(const std::string& errorMessage);

            void resetAudio();

        private:
            void ensureOnWorkerThread() const;

        private:
            const std::shared_ptr<quasar::ipc::IIpcFactory> ipcFactory_;
            const Direction direction_;
            const std::string sessionUuid_;
            std::shared_ptr<MediatorApi> mediator_;
            std::shared_ptr<LoopThread> workerThread_;
            std::shared_ptr<TimerFactory> timerFactory_;
            MediaSession::Status status_;
            Listener* listener_;
            std::shared_ptr<quasar::IUserConfigProvider> userConfigProvider_;

            std::shared_ptr<RedirectPeerConnectionObserver> connectionObserver_;

            // Config
            webrtc::PeerConnectionInterface::RTCConfiguration rtcConfig_;
            Json::Value config_;
            std::chrono::seconds keepaliveInterval_{10};

            const Json::Value callsConfig_;
            ::rtc::scoped_refptr<quasar::QuasarAudioDeviceModule> audio_;
            ::rtc::scoped_refptr<webrtc::AudioProcessing> apm_;

            std::shared_ptr<CandidatesSender> candidatesSender_;
            std::unique_ptr<StatsSender> statsSender_;

            std::unique_ptr<::rtc::Thread> webrtcSignalingThread_;
            std::unique_ptr<::rtc::Thread> webrtcWorkerThread_;

            ::rtc::scoped_refptr<webrtc::PeerConnectionFactoryInterface> peerConnectionFactory_;
            ::rtc::scoped_refptr<webrtc::PeerConnectionInterface> peerConnection_;
        };

    } // namespace rtc
} // namespace messenger
