#include "state_machine.h"

using namespace messenger::rtc;

const std::string InitialState::NAME = "InitialState";

StateMachine::StateMachine()
    : state_(new InitialState())
{
}

StateMachine::StateMachine(std::unique_ptr<State> state)
    : state_(std::move(state))
{
}

void StateMachine::setState(std::unique_ptr<State> state) {
    onStateChange(state_.get(), state.get());

    if (state_) {
        state_->exit();
    }

    state_ = std::move(state);

    if (state_) {
        state_->enter();
    }
}

const StateMachine::State* StateMachine::getState() const {
    return state_.get();
}

void StateMachine::onStateChange(State* oldState, State* newState) {
}
