#pragma once

#include <memory>
#include <string>

namespace messenger {
    namespace rtc {

        class StateMachine {
        public:
            class State {
            public:
                virtual ~State() = default;

                virtual const std::string& name() const = 0;

                virtual void enter() = 0;

                virtual void exit() = 0;
            };

        public:
            virtual ~StateMachine() = default;

            StateMachine();

            explicit StateMachine(std::unique_ptr<State> state);

            const State* getState() const;

        protected:
            void setState(std::unique_ptr<State> state);

        private:
            virtual void onStateChange(State* oldState, State* newState);

        private:
            std::unique_ptr<State> state_;
        };

        class InitialState: public StateMachine::State {
        public:
            static const std::string NAME;

            const std::string& name() const override {
                return NAME;
            }

        private:
            void enter() override {
            }

            void exit() override {
            }
        };

    } // namespace rtc
} // namespace messenger
