#include "candidates_sending_state.h"

#include "waiting_for_candidates_state.h"

#include <memory>

YIO_DEFINE_LOG_MODULE("callkit");

using namespace messenger::rtc;

const std::string SenderStateMachine::CandidatesSendingState::NAME = "CandidatesSendingState";

SenderStateMachine::CandidatesSendingState::CandidatesSendingState(SenderStateMachine* machine)
    : SenderState(machine)
{
}

void SenderStateMachine::CandidatesSendingState::enter() {
    if (machine_->unsentCandidates_.empty()) {
        YIO_LOG_ERROR_EVENT("CandidatesSendingState.EmptyUnsentCandidates", "Unexpected empty unsent candidates list");
        return;
    }

    std::vector<IceCandidate> candidates;
    const Operation operation = machine_->unsentCandidates_.front().second;

    for (const auto& it : machine_->unsentCandidates_) {
        if (it.second == operation) {
            candidates.push_back(it.first);
        }
    }

    subscription_ = machine_->mediator_->subscribe([this, operation, candidates](const MediatorApi::Message& message) {
        machine_->ensureOnWorkerThread();

        if (message.get("id", "") == requestId_) {
            machine_->removeSentCandidates(operation, candidates);
            machine_->setState(std::make_unique<WaitingForCandidatesState>(machine_));
        }
    });

    if (operation == SenderStateMachine::Operation::ADD) {
        requestId_ = machine_->mediator_->addCandidates(machine_->sessionUuid_, candidates);

    } else if (operation == SenderStateMachine::Operation::REMOVE) {
        requestId_ = machine_->mediator_->removeCandidates(machine_->sessionUuid_, candidates);

    } else {
        // Should never happen
        throw std::runtime_error("Unexpected operation");
    }
}

void SenderStateMachine::CandidatesSendingState::exit() {
    subscription_.reset(nullptr);
}
