#include "complete_sending_state.h"

#include "complete_sent_state.h"

#include <memory>

using namespace messenger::rtc;

const std::string SenderStateMachine::CompleteSendingState::NAME = "CompleteSendingState";

SenderStateMachine::CompleteSendingState::CompleteSendingState(SenderStateMachine* machine)
    : SenderState(machine)
{
}

void SenderStateMachine::CompleteSendingState::enter() {
    subscription_ = machine_->mediator_->subscribe([this](const MediatorApi::Message& message) {
        machine_->ensureOnWorkerThread();

        if (message.get("id", "") == requestId_) {
            machine_->setState(std::make_unique<CompleteSentState>(machine_));
        }
    });

    std::vector<IceCandidate> candidates;
    candidates.emplace_back();

    requestId_ = machine_->mediator_->addCandidates(machine_->sessionUuid_, candidates);
}

void SenderStateMachine::CompleteSendingState::exit() {
    subscription_.reset(nullptr);
}
