#include "config_awaiting_state.h"

#include "config_applying_state.h"

#include <memory>

using namespace messenger::rtc;

const std::string SessionStateMachine::ConfigAwaitingState::NAME = "ConfigAwaitingState";

SessionStateMachine::ConfigAwaitingState::ConfigAwaitingState(SessionStateMachine* machine)
    : SessionState(machine)
{
}

void SessionStateMachine::ConfigAwaitingState::enter() {
    subscription_ = machine_->mediator_->subscribe([this](const MediatorApi::Message& message) {
        if (message.get("method", "") == "config") {
            if (!message.isMember("params")) {
                return;
            }

            const auto& params = message["params"];

            if (!params.isMember("config")) {
                return;
            }

            machine_->setState(std::make_unique<ConfigApplyingState>(machine_, params["config"]));
        }
    });
}

void SessionStateMachine::ConfigAwaitingState::exit() {
    subscription_.reset(nullptr);
}
