#include "local_answer_creating_state.h"

#include "local_answer_setting_state.h"
#include "local_offer_creating_state.h"

#include <memory>

using namespace messenger::rtc;

void SessionStateMachine::LocalAnswerCreatingState::Observer::OnSuccess(webrtc::SessionDescriptionInterface* desc) {
    std::string sdp;
    if (!desc->ToString(&sdp)) {
        // Should never happen since answer is created by webrtc
        throw std::runtime_error("Can't serialize answer");
    }

    ::rtc::scoped_refptr<Observer> ref(this);

    machine_->workerThread_->execute([this, ref, sdp]() {
        if (inState_) {
            machine_->setState(std::make_unique<LocalAnswerSettingState>(
                machine_, sdp));

        } else {
            YIO_LOG_INFO("Already left " << LocalAnswerCreatingState::NAME);
        }
    });
}

void SessionStateMachine::LocalAnswerCreatingState::Observer::OnFailure(
    webrtc::RTCError error) {
    ::rtc::scoped_refptr<Observer> ref(this);

    machine_->workerThread_->execute([this, ref, error]() {
        if (inState_) {
            machine_->notifyFailure(error.message());

            machine_->setState(std::make_unique<LocalOfferCreatingState>(machine_, true));

        } else {
            YIO_LOG_INFO("Already left " << LocalAnswerCreatingState::NAME);
        }
    });
}

const std::string SessionStateMachine::LocalAnswerCreatingState::NAME = "LocalAnswerCreatingState";

SessionStateMachine::LocalAnswerCreatingState::LocalAnswerCreatingState(SessionStateMachine* machine)
    : NegotiatingState(machine)
    , observer_(new ::rtc::RefCountedObject<Observer>(machine))
{
}

void SessionStateMachine::LocalAnswerCreatingState::enter() {
    NegotiatingState::enter();

    observer_->enter();

    machine_->peerConnection_->CreateAnswer(observer_, webrtc::PeerConnectionInterface::RTCOfferAnswerOptions());
}

void SessionStateMachine::LocalAnswerCreatingState::exit() {
    observer_->exit();

    NegotiatingState::exit();
}
