#include "local_answer_sending_state.h"

#include "waiting_for_connection_state.h"

#include <memory>

YIO_DEFINE_LOG_MODULE("callkit");

using namespace messenger::rtc;

const std::string SessionStateMachine::LocalAnswerSendingState::NAME =
    "LocalAnswerSendingState";

SessionStateMachine::LocalAnswerSendingState::LocalAnswerSendingState(
    SessionStateMachine* machine, const std::string& answer)
    : NegotiatingState(machine)
    , answer_(answer)
{
}

void SessionStateMachine::LocalAnswerSendingState::enter() {
    NegotiatingState::enter();

    subscription_ = machine_->mediator_->subscribe(
        [this](const MediatorApi::Message& message) {
            if (message["id"] == requestId_) {
                if (message.isMember("error")) {
                    YIO_LOG_ERROR_EVENT("LocalAnswerSendingState.ErrorFromBackend", "Error returned by backend: " << message);

                    machine_->notifyFailure(quasar::jsonToString(message));
                }

                machine_->setState(std::make_unique<WaitingForConnectionState>(
                    machine_));
            }
        });

    requestId_ = machine_->mediator_->answer(machine_->sessionUuid_, answer_);
}

void SessionStateMachine::LocalAnswerSendingState::exit() {
    subscription_.reset(nullptr);

    NegotiatingState::exit();
}
