#pragma once

#include "negotiating_state.h"

namespace messenger {
    namespace rtc {

        class SessionStateMachine::LocalAnswerSendingState: public SessionStateMachine::NegotiatingState {
        public:
            LocalAnswerSendingState(SessionStateMachine* machine, const std::string& answer);

            void enter() override;

            void exit() override;

            static const std::string NAME;

            const std::string& name() const override {
                return NAME;
            }

        private:
            const std::string answer_;

            std::string requestId_;

            MediatorApi::MessageSubscription subscription_;
        };

    } // namespace rtc
} // namespace messenger
