#include "local_answer_setting_state.h"

#include "local_answer_sending_state.h"

#include <memory>

using namespace messenger::rtc;

void SessionStateMachine::LocalAnswerSettingState::Observer::OnSuccess() {
    ::rtc::scoped_refptr<Observer> ref(this);

    machine_->workerThread_->execute([this, ref]() {
        if (inState_) {
            machine_->setState(std::make_unique<LocalAnswerSendingState>(
                machine_, answer_));

        } else {
            YIO_LOG_INFO("Already left " << LocalAnswerSettingState::NAME);
        }
    });
}

void SessionStateMachine::LocalAnswerSettingState::Observer::OnFailure(
    webrtc::RTCError error) {
    ::rtc::scoped_refptr<Observer> ref(this);

    machine_->workerThread_->execute([this, ref, error]() {
        if (inState_) {
            machine_->notifyFailure(error.message());

            machine_->mediator_->reportError(
                machine_->sessionUuid_,
                error.message(),
                MediatorApi::ErrorType::INVALID_ANSWER);

        } else {
            YIO_LOG_INFO("Already left " << LocalAnswerSettingState::NAME);
        }
    });
}

const std::string SessionStateMachine::LocalAnswerSettingState::NAME = "LocalAnswerSettingState";

SessionStateMachine::LocalAnswerSettingState::LocalAnswerSettingState(SessionStateMachine* machine, const std::string& answer)
    : NegotiatingState(machine)
    , answer_(answer)
    , observer_(new ::rtc::RefCountedObject<Observer>(machine_, answer_))
{
}

void SessionStateMachine::LocalAnswerSettingState::enter() {
    NegotiatingState::enter();

    observer_->enter();

    webrtc::SdpParseError err;
    std::unique_ptr<webrtc::SessionDescriptionInterface> description(webrtc::CreateSessionDescription("answer", answer_, &err));

    if (!description) {
        // Should never happen since answer is created by webrtc
        throw std::runtime_error("Can't parse answer");
    }

    machine_->peerConnection_->SetLocalDescription(observer_, description.release());
}

void SessionStateMachine::LocalAnswerSettingState::exit() {
    observer_->exit();

    NegotiatingState::exit();
}
