#pragma once

#include "negotiating_state.h"

namespace messenger {
    namespace rtc {

        class SessionStateMachine::LocalAnswerSettingState: public SessionStateMachine::NegotiatingState {
        public:
            LocalAnswerSettingState(SessionStateMachine* machine, const std::string& answer);

            void enter() override;

            void exit() override;

            static const std::string NAME;

            const std::string& name() const override {
                return NAME;
            }

        private:
            class Observer: public webrtc::SetSessionDescriptionObserver {
            public:
                Observer(SessionStateMachine* machine, const std::string& answer)
                    : machine_(machine)
                    , answer_(answer)
                {
                }

                void OnSuccess() override;

                void OnFailure(webrtc::RTCError error) override;

                void enter() {
                    inState_ = true;
                }

                void exit() {
                    inState_ = false;
                }

            private:
                SessionStateMachine* machine_;
                const std::string answer_;

                bool inState_;
            };

        private:
            const std::string answer_;

            ::rtc::scoped_refptr<Observer> observer_;
        };

    } // namespace rtc
} // namespace messenger
