#pragma once

#include "negotiating_state.h"

namespace messenger {
    namespace rtc {

        class SessionStateMachine::LocalOfferCreatingState
            : public SessionStateMachine::NegotiatingState {
        public:
            LocalOfferCreatingState(SessionStateMachine* machine,
                                    bool performIceRestart);

            void enter() override;

            void exit() override;

            static const std::string NAME;

            const std::string& name() const override {
                return NAME;
            }

            bool shouldSkipRenegotiation() const override {
                return true;
            }

            bool negotiatingLocalOffer() const override {
                return true;
            }

        private:
            class Observer: public webrtc::CreateSessionDescriptionObserver {
            public:
                explicit Observer(SessionStateMachine* machine)
                    : machine_(machine)
                {
                }

                void OnSuccess(webrtc::SessionDescriptionInterface* desc) override;

                void OnFailure(webrtc::RTCError error) override;

                void enter() {
                    inState_ = true;
                }

                void exit() {
                    inState_ = false;
                }

            private:
                SessionStateMachine* machine_;

                bool inState_;
            };

        private:
            bool hasPlaceholderVideoTransceiver() const;

            void addPlaceholderVideoTransceiver();

        private:
            bool performIceRestart_;

            ::rtc::scoped_refptr<Observer> observer_;
        };

    } // namespace rtc
} // namespace messenger
