#include "local_offer_sending_state.h"

#include "remote_answer_receiving_state.h"

#include <memory>

YIO_DEFINE_LOG_MODULE("callkit");

using namespace messenger::rtc;

const std::string SessionStateMachine::LocalOfferSendingState::NAME = "LocalOfferSendingState";

SessionStateMachine::LocalOfferSendingState::LocalOfferSendingState(
    SessionStateMachine* machine,
    const std::string& sdp)
    : NegotiatingState(machine)
    , sdp_(sdp)
{
}

void SessionStateMachine::LocalOfferSendingState::enter() {
    NegotiatingState::enter();

    subscription_ = machine_->mediator_->subscribe([this](const MediatorApi::Message& message) {
        if (message["id"] == requestId_) {
            if (message.isMember("error")) {
                YIO_LOG_ERROR_EVENT("LocalOfferSendingState.ErrorFromBackend", "Error returned by backend: " << message);

                machine_->notifyFailure(quasar::jsonToString(message));
            }

            machine_->setState(std::make_unique<RemoteAnswerReceivingState>(machine_, sdp_));
        }
    });

    requestId_ = machine_->mediator_->offer(machine_->sessionUuid_, sdp_);
}

void SessionStateMachine::LocalOfferSendingState::exit() {
    subscription_.reset(nullptr);

    NegotiatingState::exit();
}
