#pragma once

#include "negotiating_state.h"

#include <yandex_io/callkit/rtc/media/session_state_machine.h>

namespace messenger {
    namespace rtc {

        class SessionStateMachine::LocalOfferSendingState: public SessionStateMachine::NegotiatingState {
        public:
            LocalOfferSendingState(
                SessionStateMachine* machine,
                const std::string& sdp);

            void enter() override;

            void exit() override;

            static const std::string NAME;

            const std::string& name() const override {
                return NAME;
            }

            bool negotiatingLocalOffer() const override {
                return true;
            }

        private:
            std::string sdp_;
            std::string requestId_;
            MediatorApi::MessageSubscription subscription_;
        };

    } // namespace rtc
} // namespace messenger
