#pragma once

#include "negotiating_state.h"

#include <yandex_io/callkit/rtc/media/session_state_machine.h>

namespace messenger {
    namespace rtc {

        class SessionStateMachine::LocalOfferSettingState: public SessionStateMachine::NegotiatingState {
        public:
            LocalOfferSettingState(
                SessionStateMachine* machine,
                const std::string& sdp,
                const std::string& remoteAnswer = "has no remote answer");

            void enter() override;

            void exit() override;

            static const std::string NAME;

            const std::string& name() const override {
                return NAME;
            }

            bool negotiatingLocalOffer() const override {
                return true;
            }

        private:
            class Observer: public webrtc::SetSessionDescriptionObserver {
            public:
                Observer(SessionStateMachine* machine, const std::string& sdp, const std::string& answer)
                    : machine_(machine)
                    , sdp_(sdp)
                    , answer_(answer)
                {
                }

                void OnSuccess() override;

                void OnFailure(webrtc::RTCError error) override;

                void enter() {
                    inState_ = true;
                }

                void exit() {
                    inState_ = false;
                }

            private:
                SessionStateMachine* machine_;
                const std::string& sdp_;
                const std::string& answer_;

                bool inState_;
            };

        private:
            const std::string sdp_;
            const std::string answer_;

            ::rtc::scoped_refptr<Observer> observer_;
        };

    } // namespace rtc
} // namespace messenger
