#pragma once

#include <yandex_io/callkit/rtc/media/session_state_machine.h>

#include <contrib/libs/webrtc/api/peer_connection_interface.h>

namespace messenger {
    namespace rtc {

        class SessionStateMachine::NegotiatingState
            : public SessionStateMachine::SessionState,
              public webrtc::PeerConnectionObserver {
        public:
            explicit NegotiatingState(SessionStateMachine* machine);

            void enter() override;

            void exit() override;

            virtual bool shouldSkipRenegotiation() const {
                return false;
            }

            virtual bool negotiatingLocalOffer() const {
                return false;
            }

        public:
            // PeerConnectionObserver

            void OnIceConnectionChange(
                webrtc::PeerConnectionInterface::IceConnectionState newState) override;

            void OnRenegotiationNeeded() override;

            void
            OnIceCandidate(const webrtc::IceCandidateInterface* candidate) override;

            void OnIceCandidatesRemoved(
                const std::vector<cricket::Candidate>& candidates) override;

            void OnIceGatheringChange(
                webrtc::PeerConnectionInterface::IceGatheringState newState) override;

            void OnAddTrack(
                ::rtc::scoped_refptr<webrtc::RtpReceiverInterface> receiver,
                const std::vector<::rtc::scoped_refptr<webrtc::MediaStreamInterface>>&
                    streams) override;

            void OnSignalingChange(
                webrtc::PeerConnectionInterface::SignalingState new_state) override;

            void OnDataChannel(::rtc::scoped_refptr<webrtc::DataChannelInterface>
                                   data_channel) override;

        private:
            void handleRemoteCandidatesAddition(const MediatorApi::Message& message);

            void handleRemoteCandidatesRemoving(const MediatorApi::Message& message);

            void handleRemoteOffer(const MediatorApi::Message& message);

            void handleRemoteMediaStateUpdate(const MediatorApi::Message& message);

            void acknowledge(const std::string& transactionId);

        private:
            MediatorApi::MessageSubscription mediatorSubscription_;
        };

    } // namespace rtc
} // namespace messenger
