#include "peer_connection_broken_state.h"

#include "local_offer_creating_state.h"

#include <memory>

using namespace messenger::rtc;

const std::string SessionStateMachine::PeerConnectionBrokenState::NAME = "PeerConnectionBrokenState";

SessionStateMachine::PeerConnectionBrokenState::PeerConnectionBrokenState(SessionStateMachine* machine)
    : SessionState(machine)
{
}

void SessionStateMachine::PeerConnectionBrokenState::enter() {
    machine_->status_ = MediaSession::Status::RECONNECTING;
    machine_->notifyStatusChange(MediaSession::Status::RECONNECTING);

    machine_->setState(std::make_unique<LocalOfferCreatingState>(machine_, true));
}

void SessionStateMachine::PeerConnectionBrokenState::exit() {
}
