#include "peer_connection_creating_state.h"

#include "peer_connection_creation_failed_state.h"
#include "user_media_acquiring_state.h"

#include <memory>

YIO_DEFINE_LOG_MODULE("callkit");

using namespace messenger::rtc;

const std::string SessionStateMachine::PeerConnectionCreatingState::NAME = "PeerConnectionCreatingState";

SessionStateMachine::PeerConnectionCreatingState::PeerConnectionCreatingState(SessionStateMachine* machine)
    : SessionState(machine)
{
}

void SessionStateMachine::PeerConnectionCreatingState::enter() {
    machine_->candidatesSender_ = createCandidatesSender(machine_->sessionUuid_, machine_->mediator_, machine_->workerThread_);

    machine_->peerConnection_ = machine_->peerConnectionFactory_->CreatePeerConnection(
        machine_->rtcConfig_,
        nullptr,
        nullptr,
        machine_->connectionObserver_.get());

    if (machine_->peerConnection_ == nullptr) {
        YIO_LOG_ERROR_EVENT("PeerConnectionCreatingState.CreatePeerConnectionFailed", "Can't create PeerConnection");

        machine_->setState(std::make_unique<PeerConnectionCreationFailedState>(machine_));

        return;
    }

    machine_->statsSender_ = std::make_unique<StatsSender>(
        machine_->sessionUuid_,
        machine_->mediator_,
        machine_->timerFactory_,
        machine_->workerThread_,
        machine_->keepaliveInterval_);

    machine_->statsSender_->start();

    machine_->setState(std::make_unique<UserMediaAcquiringState>(machine_));
}

void SessionStateMachine::PeerConnectionCreatingState::exit() {
}
