#include "peer_connection_creation_failed_state.h"

#include "session_disposed_state.h"

#include <memory>

YIO_DEFINE_LOG_MODULE("callkit");

using namespace messenger::rtc;

const std::string SessionStateMachine::PeerConnectionCreationFailedState::NAME = "PeerConnectionCreationFailedState";

SessionStateMachine::PeerConnectionCreationFailedState::PeerConnectionCreationFailedState(SessionStateMachine* machine)
    : SessionState(machine)
{
}

void SessionStateMachine::PeerConnectionCreationFailedState::enter() {
    YIO_LOG_ERROR_EVENT("PeerConnectionCreationFailedState.EnterFailedState", "Peer connection creation failed, now we can do nothing!");

    machine_->notifyFailure("Peer connection creation failed");

    machine_->status_ = MediaSession::Status::DISPOSED;
    machine_->notifyStatusChange(MediaSession::Status::DISPOSED);

    machine_->peerConnection_ = nullptr;
    machine_->peerConnectionFactory_ = nullptr;
    machine_->resetAudio();

    machine_->setState(std::make_unique<SessionDisposedState>(machine_));
}

void SessionStateMachine::PeerConnectionCreationFailedState::exit() {
}
